/* This file contains the vertex shader displacement mapping extension for DX8

   Basics:

        The application creates a vertex shader for doing displacement mapping
        and adaptive tessellation. At shader creation time, the application
        specifies that this shader will be used for such purpose ONLY, passing
        Matrox specific tokens in the shader constant initialization sequence.

    Parameters:

        VERTEX SHADER DECLARATION
        =========================

        DmShader:   (x,y,z,w) = (DMSHADER, DMADAPTIVE, DMLINEAR | DMNPATCH, 0)
        DmMapping:  (x,y,z,w) = (DMMAPPING, DMSEGMENTS, constant_register_offset, 0)

        CONSTANT REGISTERS
        ==================

        DmSegments: (x,y,z,w) = (segments, min_segments, max_segments, OPTIONS)

*/

#ifndef INC_MTXDMEXT_H
#define INC_MTXDMEXT_H

// -----------------------------------------------------------------------------
// H E A D E R   F I L E S
// -----------------------------------------------------------------------------

// Displacement texture formats
#define MTX_D8                             D3DFORMAT(0x102B0001)  // unsigned

// Extension block specification
#define MTX_EXT_BEGIN_X                    0x7FF4614D 
#define MTX_EXT_BEGIN_Y                    0x7FF86F72
#define MTX_EXT_BEGIN_Z                    0x7FF47845
#define MTX_EXT_BEGIN_W                    0x7FD02E31

#define MTX_EXT_END_X                      0xFFF4614D
#define MTX_EXT_END_Y                      0xFFF86F72
#define MTX_EXT_END_Z                      0xFFF47845
#define MTX_EXT_END_W                      0xFFD02E31

// Declaration group
#define MTX_EXT_NONE                       0x7FFF0000   // X
#define MTX_EXT_DMSHADER                   0x7FFF0001   // X
#define MTX_EXT_DMMAPPING                  0x7FFF0002   // X
#define MTX_EXT_DMSEGMENTS                 0x7FFE0001   // X = DMMAPPING, Y

// Options for DMSHADER tessellation mode (Y)
#define MTX_EXT_DMADAPTIVE                 0x00000001

// Options for DMSHADER interpolation mode (Z)
#define MTX_EXT_DMLINEAR                   0x00000011
#define MTX_EXT_DMNPATCH                   0x00000023

// Options for DMSHADER (W)

// Options for DMSEGMENTS (W)

// Scale the currently specified number of segments by a per-vertex scalar
// taken from the z component of the base vertex texture coordinates used
// to index the displacement map.
#define MTX_EXT_DMSEGMENTS_SCALE           0x00000001

#endif  // #ifndef INC_MTXDMEXT_H
